/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.SimpleColorBackground;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.util.ColorUtil;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import io.github.queerbric.pride.PrideFlag;
import io.github.queerbric.pride.PrideFlags;
import io.github.queerbric.pride.shape.HorizontalPrideFlagShape;
import io.github.queerbric.pride.shape.PrideFlagShape;
import io.github.queerbric.pride.shape.VerticalPrideFlagShape;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4588;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

public class RandomPrideFlagBackground
implements Background {
    private static final Background SECOND_LAYER = new SimpleColorBackground(-804253680);
    private static final HorizontalPrideFlagShape DEFAULT_RAINBOW = new HorizontalPrideFlagShape(IntList.of((int[])new int[]{-65512, -23252, -191, -16744424, -16776967, -7995267}));
    private static final Random RANDOM = new Random();
    private final PrideFlag flag;
    private final boolean nuhUh;

    RandomPrideFlagBackground(PrideFlag flag, boolean nuhUh) {
        this.flag = flag;
        this.nuhUh = nuhUh;
    }

    private PrideFlagShape getShape() {
        return this.nuhUh ? DEFAULT_RAINBOW : this.flag.getShape();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render(SpruceGuiGraphics graphics, SpruceWidget widget, int vOffset, int mouseX, int mouseY, float delta) {
        int x = widget.getX();
        int y = widget.getY();
        int width = widget.getWidth();
        int height = widget.getHeight();
        PrideFlagShape prideFlagShape = this.getShape();
        if (prideFlagShape instanceof HorizontalPrideFlagShape) {
            IntList colors;
            HorizontalPrideFlagShape horizontalPrideFlagShape = (HorizontalPrideFlagShape)prideFlagShape;
            try {
                IntList intList;
                colors = intList = horizontalPrideFlagShape.colors();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            graphics.submitGuiElement((class_11244)new SlantedPrideFlagRenderState(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)graphics.pose(), x, y, width, height, colors, null));
        } else {
            this.flag.render(graphics.vanilla(), x, y, widget.getWidth(), widget.getHeight());
        }
        SECOND_LAYER.render(graphics, widget, vOffset, mouseX, mouseY, delta);
        if (this.nuhUh) {
            class_5250 text = class_2561.method_43470((String)"Nuh uh, you're not going to remove this, try harder :3c");
            class_327 font = class_310.method_1551().field_1772;
            List lines = font.method_1728((class_5348)text, width - 8);
            int n = lines.size();
            Objects.requireNonNull(font);
            int startY = y + height - 24 - n * (9 + 2);
            for (class_5481 line : lines) {
                graphics.drawCenteredShadowedText(font, line, x + width / 2, startY, -65536);
                Objects.requireNonNull(font);
                startY += 9 + 2;
            }
        }
    }

    public static Background random() {
        PrideFlag flag = PrideFlags.getRandomFlag((Random)RANDOM);
        boolean nuhUh = flag == null || RandomPrideFlagBackground.areColorsSpoofed(flag);
        return new RandomPrideFlagBackground(flag, nuhUh);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean areColorsSpoofed(PrideFlag flag) {
        PrideFlagShape prideFlagShape = flag.getShape();
        Objects.requireNonNull(prideFlagShape);
        PrideFlagShape prideFlagShape2 = prideFlagShape;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HorizontalPrideFlagShape.class, VerticalPrideFlagShape.class}, (Object)prideFlagShape2, n)) {
            case 0: {
                IntList colors;
                HorizontalPrideFlagShape horizontalPrideFlagShape = (HorizontalPrideFlagShape)prideFlagShape2;
                try {
                    IntList intList;
                    colors = intList = horizontalPrideFlagShape.colors();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                boolean bl = RandomPrideFlagBackground.areColorsSpoofed(colors);
                return bl;
            }
            case 1: {
                IntList colors;
                VerticalPrideFlagShape verticalPrideFlagShape = (VerticalPrideFlagShape)prideFlagShape2;
                {
                    IntList intList;
                    colors = intList = verticalPrideFlagShape.colors();
                }
                boolean bl = RandomPrideFlagBackground.areColorsSpoofed(colors);
                return bl;
            }
        }
        return false;
    }

    private static boolean areColorsSpoofed(IntList colors) {
        if (colors.size() < 2) {
            return true;
        }
        int maxDist = 0;
        IntListIterator intListIterator = colors.iterator();
        while (intListIterator.hasNext()) {
            int colorA = (Integer)intListIterator.next();
            IntListIterator intListIterator2 = colors.iterator();
            while (intListIterator2.hasNext()) {
                int colorB = (Integer)intListIterator2.next();
                int dist = RandomPrideFlagBackground.colorDist(colorA, colorB);
                if (dist <= maxDist) continue;
                maxDist = dist;
            }
        }
        return maxDist < 10;
    }

    private static int colorDist(int a, int b) {
        float r = (float)(ColorUtil.argbUnpackRed((int)a) + ColorUtil.argbUnpackRed((int)b)) / 2.0f;
        int deltaR = ColorUtil.argbUnpackRed((int)a) - ColorUtil.argbUnpackRed((int)b);
        int deltaG = ColorUtil.argbUnpackGreen((int)a) - ColorUtil.argbUnpackGreen((int)b);
        int deltaB = ColorUtil.argbUnpackBlue((int)a) - ColorUtil.argbUnpackBlue((int)b);
        return (int)Math.sqrt((2.0f + r / 256.0f) * (float)deltaR * (float)deltaR + (float)(4 * deltaG * deltaG) + (2.0f + (255.0f - r) / 256.0f) * (float)deltaB * (float)deltaB);
    }

    public static final class SlantedPrideFlagRenderState
    extends Record
    implements class_11244 {
        private final RenderPipeline pipeline;
        private final class_11231 textureSetup;
        private final Matrix3x2f pose;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final IntList colors;
        @Nullable
        private final class_8030 scissorArea;
        @Nullable
        private final class_8030 bounds;

        public SlantedPrideFlagRenderState(RenderPipeline pipeline, class_11231 textureSetup, Matrix3x2f pose, int x, int y, int width, int height, IntList colors, @Nullable class_8030 scissorArea) {
            this(pipeline, textureSetup, pose, x, y, width, height, colors, scissorArea, SlantedPrideFlagRenderState.getBounds(x, y, width, height, pose, scissorArea));
        }

        public SlantedPrideFlagRenderState(RenderPipeline pipeline, class_11231 textureSetup, Matrix3x2f pose, int x, int y, int width, int height, IntList colors, @Nullable class_8030 scissorArea, @Nullable class_8030 bounds) {
            this.pipeline = pipeline;
            this.textureSetup = textureSetup;
            this.pose = pose;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.colors = colors;
            this.scissorArea = scissorArea;
            this.bounds = bounds;
        }

        public void method_70917(class_4588 vertexConsumer) {
            float partHeight = (float)this.height / ((float)this.colors.size() - 1.0f);
            float rightY = this.y;
            float leftY = this.y;
            int color = this.colors.getInt(0);
            vertexConsumer.method_70815(this.pose, (float)(this.x + this.width), rightY + partHeight).method_39415(color);
            vertexConsumer.method_70815(this.pose, (float)(this.x + this.width), rightY).method_39415(color);
            vertexConsumer.method_70815(this.pose, (float)this.x, leftY).method_39415(color);
            vertexConsumer.method_70815(this.pose, (float)this.x, leftY).method_39415(color);
            rightY += partHeight;
            for (int i = 1; i < this.colors.size() - 1; ++i) {
                color = this.colors.getInt(i);
                vertexConsumer.method_70815(this.pose, (float)(this.x + this.width), rightY + partHeight).method_39415(color);
                vertexConsumer.method_70815(this.pose, (float)(this.x + this.width), rightY).method_39415(color);
                vertexConsumer.method_70815(this.pose, (float)this.x, leftY).method_39415(color);
                vertexConsumer.method_70815(this.pose, (float)this.x, leftY + partHeight).method_39415(color);
                rightY += partHeight;
                leftY += partHeight;
            }
            color = this.colors.getInt(this.colors.size() - 1);
            vertexConsumer.method_70815(this.pose, (float)(this.x + this.width), rightY).method_39415(color);
            vertexConsumer.method_70815(this.pose, (float)this.x, leftY).method_39415(color);
            vertexConsumer.method_70815(this.pose, (float)this.x, (float)(this.y + this.height)).method_39415(color);
            vertexConsumer.method_70815(this.pose, (float)this.x, (float)(this.y + this.height)).method_39415(color);
        }

        @Nullable
        private static class_8030 getBounds(int x, int y, int width, int height, Matrix3x2f pose, @Nullable class_8030 scissorArea) {
            class_8030 defaultBounds = new class_8030(x, y, width, height).method_71523(pose);
            return scissorArea != null ? scissorArea.method_49701(defaultBounds) : defaultBounds;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SlantedPrideFlagRenderState.class, "pipeline;textureSetup;pose;x;y;width;height;colors;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x", "y", "width", "height", "colors", "scissorArea", "bounds"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SlantedPrideFlagRenderState.class, "pipeline;textureSetup;pose;x;y;width;height;colors;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x", "y", "width", "height", "colors", "scissorArea", "bounds"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SlantedPrideFlagRenderState.class, "pipeline;textureSetup;pose;x;y;width;height;colors;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x", "y", "width", "height", "colors", "scissorArea", "bounds"}, this, o);
        }

        public RenderPipeline comp_4055() {
            return this.pipeline;
        }

        public class_11231 comp_4056() {
            return this.textureSetup;
        }

        public Matrix3x2f pose() {
            return this.pose;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public IntList colors() {
            return this.colors;
        }

        @Nullable
        public class_8030 comp_4069() {
            return this.scissorArea;
        }

        @Nullable
        public class_8030 comp_4274() {
            return this.bounds;
        }
    }
}

